﻿using System;
using System.Collections.Generic;
using VA.TMP.Integration.VIMT.Shared;
using VA.TMP.Integration.VIMT.VirtualMeetingRoom.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VirtualMeetingRoom.PipelineSteps.Create
{
    /// <summary>
    /// Validate XML step.
    /// </summary>
    public class ValidateXmlStep : FilterBase<VirtualMeetingRoomCreateStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VirtualMeetingRoomCreateStateObject state)
        {
            try
            {
                PipelineUtilities.ValidateSchema("Virtual Meeting Room",
                    state.SchemaPath,
                    new List<string> { "http://DNS   /vyopta/schemas/exchange/VirtualMeetingRoom/1.0" },
                    new List<string> { "VirtualMeetingRoom.xsd" },
                    state.SerializedVirtualMeetingRoom);
            }
            catch (Exception ex)
            {
                var exceptionMessage = ex.Message;
                exceptionMessage += PipelineUtilities.BuildErrorMessage(ex);
                
                state.ExceptionOccured = true;
                state.ExceptionMessage = exceptionMessage;
            }
        }
    }
}